/*
    4D (the "Software") and the corresponding source code remain
    the exclusive property of 4D and/or its licensors and are protected by national
    and/or international legislations.
    This file is part of the source code of the Software provided under the relevant
    4D License Agreement available on http://www.4D.com/license whose compliance
    constitutes a prerequisite to any use of this file and more generally of the
    Software and the corresponding source code.
 */

getUser();

$4d.welcomeNoMore(
	function(result) {
		document.getElementById("noMore").checked = result;
});
	
$4d.env_4D_infos("short-version",
	function(result) {
		document.getElementById("version").innerHTML = result;
});
	
	$4d.env_4D_infos("long-version",
		function(result) {
			document.getElementById("version").title = result;
});

document.getElementById("banner").addEventListener("click",
	function() {
		$4d.welcomeNews();
});

try {
	document.getElementById("menu_title_0").addEventListener("click", clickMenuTitle);
}
catch(err) {}
	document.getElementById("menu_title_1").addEventListener("click", clickMenuTitle);

	let mt2 = document.getElementById("menu_title_2");
	if ( mt2 != null )
		try {
			mt2.addEventListener("click", clickMenuTitle);
		}
		catch(err) {}

try {
	document.getElementById("noMore").addEventListener("change", noMore);
}
catch(err) {}
try {
document.getElementById("log").addEventListener("click", sign);
}
catch(err) {}
try {
	document.getElementById("store").addEventListener("click", store);
}
catch(err) {}


var x;
x = document.getElementsByClassName("menu_item_0")
for (i = 0; i < x.length; i++) {
	x[i].addEventListener("click", clickMenuItem);
}

x = document.getElementsByClassName("menu_item_1")
for (i = 0; i < x.length; i++) {
	x[i].addEventListener("click", clickMenuItem);
}

x = document.getElementsByClassName("menu_item_2")
for (i = 0; i < x.length; i++) {
	x[i].addEventListener("click", clickMenuItem);
}


try {
	if(document.getElementById("recent_databases").childElementCount > 0) {
		openMenu('menu_title_0');
	}
}

catch(err) {
	openMenu('menu_title_1');	
}

function store() {
	$4d.waString("Url_Store",
		function(result) {
			window.open(result);
	});
}

function getUser() {
	$4d.welcomeUser(
		function(result) {
			document.d4user = result;
			displayUser();
	});
}

function displayUser() {
	var user = document.d4user;
	try {
		(user != null) ? isLogged(user) : mustLog();
	}
	catch(err) {
		mustLog();
	}
}

function sign() {
	var user = document.d4user;
	if (user == undefined) {
		user = {};
	}
	$4d.welcomeUser(user, function(result) {
		document.d4user = result;
		displayUser();
	});
}

function isLogged(user) {
	if (user.firstName != undefined) {
		$4d.waString('Wel_hello', function(result) {
			document.getElementById("welcome").innerHTML = result.replace( /{user}/, user.firstName);   
		});
		var log = document.getElementById("log");
		log.setAttribute("class", "signout");
		$4d.waString("Wel_signout",
			function(result) {
				log.innerHTML = result;
			});
	} else {
		mustLog();
	}
}

function mustLog() {
	$4d.waString("Wel_welcome", function(result) {
			document.getElementById("welcome").innerHTML = result;
		});
	var log = document.getElementById("log");
	log.setAttribute("class", "signin");		
	$4d.waString("Wel_signIn",
		function(result) {
			log.innerHTML = result;
		});
}

function clickMenuTitle() {
	openMenu(this.id);	
}

function openMenu(menu) {
	var me, item;
	switch (menu) {
	case 'menu_title_0':
		me = document.getElementById("menu_title_0");
		me.setAttribute("class", "opened");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'inherit';
		}
		me = document.getElementById("menu_title_1");
		me.setAttribute("class", "closed");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'none';
		}
		me = document.getElementById("menu_title_2");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}		
		break;
		
	case 'menu_title_1':
		me = document.getElementById("menu_title_0");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}
		me = document.getElementById("menu_title_1");
		me.setAttribute("class", "opened");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'inherit';
		}
		me = document.getElementById("menu_title_2");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}	
		break;		
	
	case 'menu_title_2':
		me = document.getElementById("menu_title_0");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}
		me = document.getElementById("menu_title_1");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}
		me = document.getElementById("menu_title_2");
		me.setAttribute("class", "opened");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'inherit';
		}
		break;
		
	}
}

function clickMenuItem() {		
	switch (this.id) {
		case '1_1':
			waMessage('connectTo4dServer');
			break;
		case '1_2':
			waMessage('openALocalApplication');
			break;
		case '1_3':
			waMessage('createANewApplication');	
			break;
		case '2_1':
			waMessage('trial');	
			break;
						
		default:
			waMessage('4dlink_'+this.getAttribute("path"));
	}
}

function noMore() {
	$4d.welcomeNoMore(document.getElementById("noMore").checked);
}